DROP INDEX VOA.ATHLVLCOD_UK;

CREATE UNIQUE INDEX VOA.ATHLVLCOD_UK ON VOA.AUTHENTICATION_LEVEL
(CODE)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ATHLVLNAM_UK;

CREATE UNIQUE INDEX VOA.ATHLVLNAM_UK ON VOA.AUTHENTICATION_LEVEL
(NAME)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ATHLVL_H_PK;

CREATE UNIQUE INDEX VOA.ATHLVL_H_PK ON VOA.AUTHENTICATION_LEVEL_H
(AUTHENTICATION_LVL_H_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ATHLVL_PK;

CREATE UNIQUE INDEX VOA.ATHLVL_PK ON VOA.AUTHENTICATION_LEVEL
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ENRFRMTYPCOD_UK;

CREATE UNIQUE INDEX VOA.ENRFRMTYPCOD_UK ON VOA.ENROLLMENT_FORM_TYPE
(CODE)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ENRFRMTYPNAM_UK;

CREATE UNIQUE INDEX VOA.ENRFRMTYPNAM_UK ON VOA.ENROLLMENT_FORM_TYPE
(NAME)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ENRFRMTYP_H_PK;

CREATE UNIQUE INDEX VOA.ENRFRMTYP_H_PK ON VOA.ENROLLMENT_FORM_TYPE_H
(ENROLLMENT_FORM_TYP_H_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.ENRFRMTYP_PK;

CREATE UNIQUE INDEX VOA.ENRFRMTYP_PK ON VOA.ENROLLMENT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPDATA_PK;

CREATE UNIQUE INDEX VOA.VOAENRAPPDATA_PK ON VOA.VOA_ENROLLMENT_APP_DATA
(VOA_ENROLLMENT_APP_DATA_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPDAT_VOAENRAPP_FK_I;

CREATE INDEX VOA.VOAENRAPPDAT_VOAENRAPP_FK_I ON VOA.VOA_ENROLLMENT_APP_DATA
(VOA_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE M_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPSTATCOD_UK;

CREATE UNIQUE INDEX VOA.VOAENRAPPSTATCOD_UK ON VOA.VOA_ENROLLMENT_APP_STATUS
(CODE)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPSTATNAM_UK;

CREATE UNIQUE INDEX VOA.VOAENRAPPSTATNAM_UK ON VOA.VOA_ENROLLMENT_APP_STATUS
(NAME)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPSTAT_H_PK;

CREATE UNIQUE INDEX VOA.VOAENRAPPSTAT_H_PK ON VOA.VOA_ENROLLMENT_APP_STATUS_H
(VOA_ENROLLMENT_APP_STAT_H_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPPSTAT_PK;

CREATE UNIQUE INDEX VOA.VOAENRAPPSTAT_PK ON VOA.VOA_ENROLLMENT_APP_STATUS
(VOA_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_ATHLVL_FK_I;

CREATE INDEX VOA.VOAENRAPP_ATHLVL_FK_I ON VOA.VOA_ENROLLMENT_APPLICATION
(AUTHENTICATION_LEVEL_ID)
LOGGING
TABLESPACE M_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_ENRFRMTYP_FK_I;

CREATE INDEX VOA.VOAENRAPP_ENRFRMTYP_FK_I ON VOA.VOA_ENROLLMENT_APPLICATION
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_H_PK;

CREATE UNIQUE INDEX VOA.VOAENRAPP_H_PK ON VOA.VOA_ENROLLMENT_APPLICATION_H
(VOA_ENROLLMENT_APP_H_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_PK;

CREATE UNIQUE INDEX VOA.VOAENRAPP_PK ON VOA.VOA_ENROLLMENT_APPLICATION
(VOA_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE S_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_PRSN_FK_I;

CREATE INDEX VOA.VOAENRAPP_PRSN_FK_I ON VOA.VOA_ENROLLMENT_APPLICATION
(PERSON_ID)
LOGGING
TABLESPACE M_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_VETIDTYP_FK_I;

CREATE INDEX VOA.VOAENRAPP_VETIDTYP_FK_I ON VOA.VOA_ENROLLMENT_APPLICATION
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOAENRAPP_VOAENRAPPSTA_FK_I;

CREATE INDEX VOA.VOAENRAPP_VOAENRAPPSTA_FK_I ON VOA.VOA_ENROLLMENT_APPLICATION
(VOA_ENROLLMENT_APP_STATUS_ID)
LOGGING
TABLESPACE M_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOARSB_PK;

CREATE UNIQUE INDEX VOA.VOARSB_PK ON VOA.VOA_RESUBMISSION
(VOA_RESUBMISSION_ID)
LOGGING
TABLESPACE L_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VOA.VOARSB_VOAENRAPP_FK_I;

CREATE INDEX VOA.VOARSB_VOAENRAPP_FK_I ON VOA.VOA_RESUBMISSION
(VOA_ENROLLMENT_APP_ID)
LOGGING
TABLESPACE L_VOA_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
